<?php

namespace App\Models\Company;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Project extends Model 
{

    protected $table = 'projects';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function appointment()
    {
        return $this->belongsTo('App\Models\HR\Appointment', 'appointment_id');
    }

    public function costCode()
    {
        return $this->belongsTo('App\Models\Finance\CostCode', 'cost_code_id');
    }

    public function document_brief()
    {
        return $this->belongsTo('App\Models\Company\Document', 'document_brief_id');
    }

    public function document_plan()
    {
        return $this->belongsTo('App\Models\Company\Document', 'document_plan_id');
    }

    public function document_lessons_learned()
    {
        return $this->belongsTo('App\Models\Company\Document', 'document_lessons_learned_id');
    }

    public function document_closure()
    {
        return $this->belongsTo('App\Models\Company\Document', 'document_closure_id');
    }

}